/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.google.common.collect.ImmutableList;
import com.ninni.spawn.entity.Hamster;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HamsterModel<E extends Hamster>
extends AgeableListModel<E> {
    public static final String RIGHT_CHEEK = "right_cheek";
    public static final String LEFT_CHEEK = "left_cheek";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;
    private final ModelPart rightCheek;
    private final ModelPart rightEar;
    private final ModelPart leftLeg;
    private final ModelPart leftArm;
    private final ModelPart leftCheek;
    private final ModelPart leftEar;
    private final ModelPart tail;

    public HamsterModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.rightLeg = this.root.m_171324_("right_leg");
        this.rightArm = this.root.m_171324_("right_arm");
        this.leftLeg = this.root.m_171324_("left_leg");
        this.leftArm = this.root.m_171324_("left_arm");
        this.tail = this.body.m_171324_("tail");
        this.rightCheek = this.body.m_171324_(RIGHT_CHEEK);
        this.rightEar = this.body.m_171324_("right_ear");
        this.leftCheek = this.body.m_171324_(LEFT_CHEEK);
        this.leftEar = this.body.m_171324_("left_ear");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.75f, -3.0f, -4.5f, 7.0f, 6.0f, 9.0f), PartPose.m_171419_((float)0.25f, (float)20.0f, (float)-0.5f));
        PartDefinition leftCheek = body.m_171599_(LEFT_CHEEK, CubeListBuilder.m_171558_().m_171514_(23, 6).m_171481_(-1.0f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)2.5f, (float)2.4f, (float)-3.4f));
        PartDefinition rightCheek = body.m_171599_(RIGHT_CHEEK, CubeListBuilder.m_171558_().m_171514_(23, 6).m_171480_().m_171481_(-2.0f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f).m_171555_(false), PartPose.m_171419_((float)-1.15f, (float)2.4f, (float)-3.4f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f), PartPose.m_171419_((float)-0.25f, (float)1.0f, (float)4.5f));
        PartDefinition rightEar = body.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-2.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f), PartPose.m_171423_((float)-3.75f, (float)-2.5f, (float)-3.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leftEar = body.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171480_().m_171481_(0.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f).m_171555_(false), PartPose.m_171423_((float)3.25f, (float)-2.5f, (float)-3.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)-1.5f, (float)23.0f, (float)2.0f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f), PartPose.m_171419_((float)-1.5f, (float)23.0f, (float)-2.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171480_().m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)23.0f, (float)2.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171480_().m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)23.0f, (float)-2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition getStandingLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-3.75f, -7.0f, -1.5f, 7.0f, 10.0f, 6.0f), PartPose.m_171419_((float)0.25f, (float)21.0f, (float)-0.5f));
        PartDefinition leftCheek = body.m_171599_(LEFT_CHEEK, CubeListBuilder.m_171558_().m_171514_(23, 6).m_171481_(-1.0f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)2.5f, (float)-1.6f, (float)-0.4f));
        PartDefinition rightCheek = body.m_171599_(RIGHT_CHEEK, CubeListBuilder.m_171558_().m_171514_(23, 6).m_171480_().m_171481_(-2.0f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f).m_171555_(false), PartPose.m_171419_((float)-1.15f, (float)-1.6f, (float)-0.4f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f), PartPose.m_171419_((float)-0.25f, (float)1.0f, (float)4.5f));
        PartDefinition rightEar = body.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-2.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f), PartPose.m_171423_((float)-3.75f, (float)-6.5f, (float)-0.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leftEar = body.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171480_().m_171481_(0.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f).m_171555_(false), PartPose.m_171423_((float)3.25f, (float)-6.5f, (float)-0.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171423_((float)-3.5f, (float)23.0f, (float)-2.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f), PartPose.m_171423_((float)-2.5f, (float)20.0f, (float)-2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171480_().m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)23.0f, (float)-2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171480_().m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)20.0f, (float)-2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(E entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float speed = 1.0f;
        float degree = 1.0f;
        float pi = (float)Math.PI;
        float q = ((Hamster)((Object)entity)).getPuffTicks();
        this.leftCheek.f_233553_ = 2.0f * q;
        this.leftCheek.f_233555_ = 2.0f * q;
        this.leftCheek.f_233554_ = 2.0f * q;
        this.rightCheek.f_233553_ = 2.0f * q;
        this.rightCheek.f_233555_ = 2.0f * q;
        this.rightCheek.f_233554_ = 2.0f * q;
        this.leftEar.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * 0.6f * 0.25f - 0.6f;
        this.rightEar.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.2f + pi)) * degree * 0.6f * 0.25f + 0.6f;
        this.body.f_104201_ = Mth.m_14089_((float)(2.0f + limbAngle * 0.6f * speed)) * 0.6f * limbDistance + (((Hamster)((Object)entity)).isStanding() ? 21.0f : (entity.m_21825_() ? 21.0f : 20.0f));
        this.body.f_104204_ = Mth.m_14089_((float)(1.0f + limbAngle * 1.0f * speed)) * 0.2f * limbDistance;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6f * speed)) * 1.4f * limbDistance;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6f * speed + pi)) * 1.4f * limbDistance;
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6f * speed + pi)) * 1.4f * limbDistance + (((Hamster)((Object)entity)).isStanding() ? -0.3927f : 0.0f);
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6f * speed)) * 1.4f * limbDistance + (((Hamster)((Object)entity)).isStanding() ? -0.3927f : 0.0f);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.leftLeg, (Object)this.rightArm, (Object)this.rightLeg);
    }
}

